package de.uni_hildesheim.sse.trans.in.rsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.ssehub.easy.varModel.cst.Variable;

/**
 * All information items of one KConfig variable, read out of a RSF file.
 * @author El-Sharkawy
 *
 */
class RSFItem {
    private String name;
    private Datatype type;
    
    private RSFDefaultAndPromptCondition defaultAndPromptCondition;
    
    private List<Variable> comparisonVariables;
    
    private String choiceParent;
   
    
    /**
     * Sole constructor for this datatype.
     * @param name The name of the KConfig variable.O
     */
    RSFItem(String name) {
        this.name = name;
        defaultAndPromptCondition = new RSFDefaultAndPromptCondition(this);
    }
   
    /**
     * Getter for the name of the {@link RSFItem}.
     * @return The name of this item.
     */
    public String getName() {
        return name;
    }
    
    /**
    * Setter for the {@link Datatype}.
    * @param type The Datatype of the item, maybe in small letters.
    */
    public void setDatatype(String type) {
        this.type = Datatype.getDatatype(type); 
    }

    /**
     * Getter for the Datatype of the variable.
     * @return The Datatype of the item.
     * @return
     */
    public Datatype getDatatype() {
        return type;
    }
    
    /**
     * Getter for the {@link RSFDefaultAndPromptCondition} for this variable.
     * @return The {@link RSFDefaultAndPromptCondition} of this variable.
     */
    public RSFDefaultAndPromptCondition getDefaultAndPromptCondition() {
        return defaultAndPromptCondition;
    }
    
    /**
     * Adds a created comparison variable found in a constraint.
     * @param variable The variable created from a comparison found in a constraint (e.g. STR=n)
     */
    public void addComparisonVariable(Variable variable) {
        if (comparisonVariables == null) {
            comparisonVariables = new ArrayList<Variable>();
        }
        comparisonVariables.add(variable);
    }
    
    /**
     * Returns a {@link List} of all variables created from comparisons found in expressions.
     * @return An unmodifiable {@link List} of variables
     */
    public List<Variable> getComparisonVariables() {
        List<Variable> result = null;
        if (comparisonVariables != null) {
            result = Collections.unmodifiableList(comparisonVariables);
        }
        return result;
    }
    
    /**
     * Sets the name of the choice if this RSFItem is a ChoiceItem.
     * @param parent The name of the choice this item belongs to (<code>null</code> if none).
     */
    public void setChoiceParent(String parent) {
        choiceParent = parent;
    }
    
    /**
     * Gets the name of the choice this RSFItem belongs to.
     * @return The name of the parent choice; <code>null</code> if this item isn't a ChoiceItem.
     */
    public String getChoiceParent() {
        return choiceParent;
    }
    
    @Override
    public String toString() {
        return type.name() + " " + name;
    }
}
