package de.uni_hildesheim.sse.trans.out;

import java.io.StringWriter;

import org.junit.Assert;
import org.junit.Test;

import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlKeyWords;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;

/**
 * Tests the {@link DimacsWriter} class.
 * 
 * @author Adam Krafczyk
 */
public class DimacsWriterTest {
    /**
     * Tests the write method.
     */
    @Test
    public void testWrite() {
        Project project = new Project("testModel");
        
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        
        project.add(declA);
        project.add(declB);
        project.add(declC);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        Variable varC = new Variable(declC);
        
        OCLFeatureCall termA1 = new OCLFeatureCall(varA, OclKeyWords.OR, new OCLFeatureCall(varB, OclKeyWords.NOT));
        OCLFeatureCall completeTerm1 = new OCLFeatureCall(termA1, OclKeyWords.OR, varC);
        
        OCLFeatureCall termA2 = new OCLFeatureCall(new OCLFeatureCall(varA, OclKeyWords.NOT), OclKeyWords.OR, varB);
        OCLFeatureCall completeTerm2 = new OCLFeatureCall(termA2, OclKeyWords.OR,
                new OCLFeatureCall(varC, OclKeyWords.NOT));
        
        Constraint constraint1 = null;
        Constraint constraint2 = null;
        try {
            constraint1 = new Constraint(completeTerm1, project);
            constraint2 = new Constraint(completeTerm2, project);
        } catch (CSTSemanticException e) {
            // Can't happen...
            Assert.fail();
        }
        project.add(constraint1);
        project.add(constraint2);
        
        StringWriter stringWriter = new StringWriter();
        DimacsWriter writer = new DimacsWriter(project, stringWriter);
        writer.write("A test-file", "1.0");
        //System.out.println(stringWriter.toString());
        
        Assert.assertEquals("c A test-file" + IvmlKeyWords.LINEFEED
            + "c Version 1.0" + IvmlKeyWords.LINEFEED
            + DimacsWriter.HELP
            + "c 1 a" + IvmlKeyWords.LINEFEED
            + "c 2 b" + IvmlKeyWords.LINEFEED
            + "c 3 c" + IvmlKeyWords.LINEFEED
            + "p cnf 3 2" + IvmlKeyWords.LINEFEED
            + "3 -2 1 0" + IvmlKeyWords.LINEFEED
            + "-3 2 -1 0" + IvmlKeyWords.LINEFEED, stringWriter.toString());
    }
    
}
