package de.uni_hildesheim.sse.trans.convert;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;
import net.ssehub.easy.varModel.model.filter.DeclrationInConstraintFinder;

/**
 * Tries to simplify a {@link ConstraintSyntaxTree} by expanding a OR (b AND c)
 * to (a OR b) AND (a OR c).
 * Only works properly if the {@link ConstraintSyntaxTree} only contains AND,
 * OR and NOT. First call accept(), then getResult() to get the result.
 * 
 * @author Adam Krafczyk
 */
class CSTExpander implements IConstraintTreeVisitor {
    
//    private static final EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(CSTSimplifier.class, Main.ID);
    
    private int minLength;
    
    private boolean expand;
    
    private String previousOperation;
    
    private ConstraintSyntaxTree result;
    
    /**
     * Creates a {@link CSTSimplifier}.
     * 
     * @param minLength The minimum length of a treepart to expand.
     */
    public CSTExpander(int minLength) {
        this.minLength = minLength;
    }
    
//    /**
//     * Getter for the {@link ConstraintSyntaxTree}s created after an accept call.
//     * If empty then no simplification of the tree could be found.
//     * @return An unmodifiable list of {@link ConstraintSyntaxTree}s, to be
//     * interpreted as AND'd together, representing the
//     * {@link ConstraintSyntaxTree} that accept()'d this visitor.
//     */
//    public List<ConstraintSyntaxTree> getTrees() {
//        return Collections.unmodifiableList(trees);
//    }
    
    /**
     * Getter for the {@link ConstraintSyntaxTree}s created after an accept call.
     * If <code>null</code> then no simplification of the tree could be found.
     * @return The modified {@link ConstraintSyntaxTree}.
     */
    public ConstraintSyntaxTree getResult() {
        return result;
    }
    
    /**
     * Clears the result to reuse the same expander several times.
     */
    public void clearResult() {
        result = null;
    }
    
    /**
     * Returns the "length" of a {@link ConstraintSyntaxTree}.
     * @param cst The {@link ConstraintSyntaxTree} to get the "length" of.
     * @return The "length" (i.e. the number of variables in the {@link ConstraintSyntaxTree}).
     */
    private int getSyntaxTreeLength(ConstraintSyntaxTree cst) {
        return new DeclrationInConstraintFinder(cst).getDeclarations().size();
    }
    
    @Override
    public void visitConstantValue(ConstantValue value) {}

    @Override
    public void visitVariable(Variable variable) {}

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {}

    @Override
    public void visitComment(Comment comment) {}

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        String currentOperation = call.getOperation();
        if (currentOperation.equals(OclKeyWords.AND)
                && previousOperation != null
                && previousOperation.equals(OclKeyWords.OR)) {
            
            expand = true;
            return; // don't fall into the if block below
            
        } else  {
            boolean left = true;
            
            previousOperation = call.getOperation();
            if (getSyntaxTreeLength(call.getOperand()) >= minLength) {
                call.getOperand().accept(this);
            }
            
            left = false;
            
            if (currentOperation.equals(OclKeyWords.OR)
                    || currentOperation.equals(OclKeyWords.AND)) {
                previousOperation = call.getOperation();
                if (getSyntaxTreeLength(call.getParameter(0)) >= minLength) {
                    call.getParameter(0).accept(this);
                }
            }
            
            if (expand) {
                ConstraintSyntaxTree a;
                ConstraintSyntaxTree b;
                ConstraintSyntaxTree c;
                if (left) {
                    // "call" is currently an OR with an AND at the left:
                    // (b AND c) OR a
                    a = call.getParameter(0);
                    OCLFeatureCall andCall = (OCLFeatureCall) call.getOperand();
                    b = andCall.getOperand();
                    c = andCall.getParameter(0);
                    
                } else {
                    // "call" is currently an OR with an AND at the right:
                    // a OR (b AND c)
                    a = call.getOperand();
                    OCLFeatureCall andCall = (OCLFeatureCall) call.getParameter(0);
                    b = andCall.getOperand();
                    c = andCall.getParameter(0);
                }
                // construct the new call
                OCLFeatureCall newLeft = new OCLFeatureCall(a, OclKeyWords.OR, b);
                OCLFeatureCall newRight = new OCLFeatureCall(a, OclKeyWords.OR, c);
                result = new OCLFeatureCall(newLeft, OclKeyWords.AND, newRight);
            }
        }
    }
//        switch (state) {
//        case INITIAL:
//            if (call.getOperation().equals(OclKeyWords.OR)) {
//                LOGGER.info("Highest operation is an OR");
//                
//                state = State.EXPAND;
//                
//                call.getOperand().accept(this);
//                ConstraintSyntaxTree passedOperand = passUp;
//                passUp = null;
//                
//                if (leftTree != null && rightTree != null) {
//                    trees.add(new OCLFeatureCall(leftTree, OclKeyWords.OR, call.getParameter(0)));
//                    trees.add(new OCLFeatureCall(rightTree, OclKeyWords.OR, call.getParameter(0)));
//                } else {
//                    
//                    call.getParameter(0).accept(this);
//                    ConstraintSyntaxTree passedParameter = passUp;
//                    passUp = null;
//                    
//                    if (leftTree != null && rightTree != null) {
//                        trees.add(new OCLFeatureCall(leftTree, OclKeyWords.OR, call.getOperand()));
//                        trees.add(new OCLFeatureCall(rightTree, OclKeyWords.OR,
//                                call.getOperand()));
//                    }
//                    
//                    if (passedOperand != null) {
//                        if (passedParameter != null) {
//                            trees.add(new OCLFeatureCall(passedOperand, OclKeyWords.OR, passedParameter));
//                        } else {
//                            trees.add(new OCLFeatureCall(passedOperand, OclKeyWords.OR, call.getParameter(0)));
//                        }
//                    } else {
//                        if (passedParameter != null) {
//                            trees.add(new OCLFeatureCall(call.getOperand(), OclKeyWords.OR, passedParameter));
//                        }
//                    }
//                }
//                
//                state = State.INITIAL;
//                
//            } else if (call.getOperation().equals(OclKeyWords.AND)) {
//                LOGGER.info("Highest operation is an AND");
//                // split tree
//                trees.add(call.getOperand());
//                trees.add(call.getParameter(0));
//            }
//            break;
//            
//        case EXPAND: // highest operand is an OR
//            if (call.getOperation().equals(OclKeyWords.AND)) {
//                LOGGER.info("Second highest operation is an AND");
//                
//                leftTree = call.getOperand();
//                rightTree = call.getParameter(0);
//            } else if (call.getOperation().equals(OclKeyWords.NOT)) {
//                LOGGER.info("Second highest operation is a NOT");
//                
//                state = State.NEGATE_EXPAND;
//                
//                call.getOperand().accept(this);
//                
//                state = State.EXPAND;
//            }
//            break;
//            
//        case NEGATE_EXPAND: // highest operand is an OR; second highest is a NOT
//            // if this operation is an OR then expand the NOT into it
//            if (call.getOperation().equals(OclKeyWords.OR)) {
//                LOGGER.info("Third highest (negated) operation is an OR");
//                leftTree = new OCLFeatureCall(call.getOperand(), OclKeyWords.NOT);
//                rightTree = new OCLFeatureCall(call.getParameter(0), OclKeyWords.NOT);
//                break;
//            }
//            state = State.NEGATE;
//            
//            // fall through
//        case NEGATE: // some level below a NOT
//            // recursively expand the not further down into the tree
//            
//            if (call.getOperation().equals(OclKeyWords.AND)) {
//                LOGGER.info("Negating an AND");
//                
//                call.getOperand().accept(this);
//                ConstraintSyntaxTree leftSide = passUp;
//                passUp = null;
//                if (leftSide == null) {
//                    leftSide = new OCLFeatureCall(call.getOperand(), OclKeyWords.NOT);
//                }
//                
//                call.getParameter(0).accept(this);
//                ConstraintSyntaxTree rightSide = passUp;
//                passUp = null;
//                if (rightSide == null) {
//                    rightSide = new OCLFeatureCall(call.getParameter(0), OclKeyWords.NOT);
//                }
//                
//                passUp = new OCLFeatureCall(leftSide, OclKeyWords.OR, rightSide);
//                
//            } else if (call.getOperation().equals(OclKeyWords.OR)) {
//                LOGGER.info("Negating an OR");
//                
//                call.getOperand().accept(this);
//                ConstraintSyntaxTree leftSide = passUp;
//                passUp = null;
//                if (leftSide == null) {
//                    leftSide = new OCLFeatureCall(call.getOperand(), OclKeyWords.NOT);
//                }
//                
//                call.getParameter(0).accept(this);
//                ConstraintSyntaxTree rightSide = passUp;
//                passUp = null;
//                if (rightSide == null) {
//                    rightSide = new OCLFeatureCall(call.getParameter(0), OclKeyWords.NOT);
//                }
//                
//                passUp = new OCLFeatureCall(leftSide, OclKeyWords.AND, rightSide);
//                
//            } else if (call.getOperation().equals(OclKeyWords.NOT)) {
//                LOGGER.info("Negating a NOT");
//                
//                passUp = call.getOperand();
//            }
//            break;
//            
//        default:
//            break;
//        }

    @Override
    public void visitLet(Let let) {}

    @Override
    public void visitIfThen(IfThen ifThen) {}

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {}

    @Override
    public void visitCompoundAccess(CompoundAccess access) {}

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {}

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {}

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {}

    @Override
    public void visitSelf(Self self) {}

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {}

}
