package de.uni_hildesheim.sse.trans;

import org.apache.commons.cli.HelpFormatter;

import de.uni_hildesheim.sse.trans.cli.Arguments;
import de.uni_hildesheim.sse.trans.cli.ArgumentsParser;
import de.uni_hildesheim.sse.trans.in.InputType;
import de.uni_hildesheim.sse.trans.out.OutputType;

/**
 * Starting point for the whole translation.
 * @author El-Sharkawy
 *
 */
public class Main {

    /**
     * Main-Method of this translator.
     * @param args Pass no arguments to this program to get a helpful message.
     */
    public static void main(String[] args) {
        Arguments arguments = ArgumentsParser.parse(args);
        
        if (arguments.isHelp()) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("ModelTranslator", ArgumentsParser.OPTIONS);
        } else {
            ModelTranslator.translate(arguments.getInputFile(), arguments.getOutputFile(), InputType.MODEL,
                OutputType.IVML, arguments.getComment(), arguments.getVersion());
        }
    }
}
