package de.uni_hildesheim.sse.trans.out;


/**
 * General interface for all model writers, which write {@link de.uni_hildesheim.sse.model.varModel.Project}s
 * to the file system.
 * @author El-Sharkawy
 *
 */
public interface IModelWriter {
    
    /**
     * Writes the given project to the file system.
     * @param comment An optional comment (e.g. information about the translated model), can be <tt>null</tt>.
     * @param version Optionally the version of the translated model. Can be <tt>null</tt>. If not <tt>null</tt>,
     *     it must be in {@link de.uni_hildesheim.sse.utils.modelManagement.Version#Version(String)} syntax.
     */
    public void write(String comment, String version);
}
