/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_9c90c2a.core.internal.instr;

import org.jacoco.agent.rt.internal_9c90c2a.asm.ClassVisitor;
import org.jacoco.agent.rt.internal_9c90c2a.asm.FieldVisitor;
import org.jacoco.agent.rt.internal_9c90c2a.asm.Label;
import org.jacoco.agent.rt.internal_9c90c2a.asm.MethodVisitor;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.flow.ClassProbesVisitor;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.flow.MethodProbesVisitor;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.instr.DuplicateFrameEliminator;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.instr.InstrSupport;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.instr.MethodInstrumenter;
import org.jacoco.agent.rt.internal_9c90c2a.core.internal.instr.ProbeInserter;
import org.jacoco.agent.rt.internal_9c90c2a.core.runtime.IExecutionDataAccessorGenerator;

public class ClassInstrumenter
extends ClassProbesVisitor {
    private static final Object[] STACK_ARRZ = new Object[]{"[Z"};
    private static final Object[] NO_LOCALS = new Object[0];
    private final long id;
    private final IExecutionDataAccessorGenerator accessorGenerator;
    private IProbeArrayStrategy probeArrayStrategy;
    private String className;
    private boolean withFrames;
    private int probeCount;

    public ClassInstrumenter(long id, IExecutionDataAccessorGenerator accessorGenerator, ClassVisitor cv) {
        super(cv);
        this.id = id;
        this.accessorGenerator = accessorGenerator;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.withFrames = (version & 0xFF) >= 50;
        this.probeArrayStrategy = (access & 0x200) == 0 ? new ClassTypeStrategy() : new InterfaceTypeStrategy();
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        InstrSupport.assertNotInstrumented(name, this.className);
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        InstrSupport.assertNotInstrumented(name, this.className);
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        DuplicateFrameEliminator frameEliminator = new DuplicateFrameEliminator(mv);
        ProbeInserter probeVariableInserter = new ProbeInserter(access, desc, frameEliminator, this.probeArrayStrategy);
        return new MethodInstrumenter(probeVariableInserter, probeVariableInserter);
    }

    public void visitTotalProbeCount(int count) {
        this.probeCount = count;
    }

    public void visitEnd() {
        this.probeArrayStrategy.addMembers(this.cv);
        super.visitEnd();
    }

    private class InterfaceTypeStrategy
    implements IProbeArrayStrategy {
        private InterfaceTypeStrategy() {
        }

        public int storeInstance(MethodVisitor mv, int variable) {
            int maxStack = ClassInstrumenter.this.accessorGenerator.generateDataAccessor(ClassInstrumenter.this.id, ClassInstrumenter.this.className, ClassInstrumenter.this.probeCount, mv);
            mv.visitVarInsn(58, variable);
            return maxStack;
        }

        public void addMembers(ClassVisitor delegate) {
        }
    }

    private class ClassTypeStrategy
    implements IProbeArrayStrategy {
        private ClassTypeStrategy() {
        }

        public int storeInstance(MethodVisitor mv, int variable) {
            mv.visitMethodInsn(184, ClassInstrumenter.this.className, "$jacocoInit", "()[Z");
            mv.visitVarInsn(58, variable);
            return 1;
        }

        public void addMembers(ClassVisitor delegate) {
            this.createDataField();
            this.createInitMethod(ClassInstrumenter.this.probeCount);
        }

        private void createDataField() {
            ClassInstrumenter.this.cv.visitField(4234, "$jacocoData", "[Z", null, null);
        }

        private void createInitMethod(int probeCount) {
            MethodVisitor mv = ClassInstrumenter.this.cv.visitMethod(4122, "$jacocoInit", "()[Z", null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, ClassInstrumenter.this.className, "$jacocoData", "[Z");
            mv.visitInsn(89);
            Label alreadyInitialized = new Label();
            mv.visitJumpInsn(199, alreadyInitialized);
            mv.visitInsn(87);
            int size = this.genInitializeDataField(mv, probeCount);
            if (ClassInstrumenter.this.withFrames) {
                mv.visitFrame(-1, 0, NO_LOCALS, 1, STACK_ARRZ);
            }
            mv.visitLabel(alreadyInitialized);
            mv.visitInsn(176);
            mv.visitMaxs(Math.max(size, 2), 0);
            mv.visitEnd();
        }

        private int genInitializeDataField(MethodVisitor mv, int probeCount) {
            int size = ClassInstrumenter.this.accessorGenerator.generateDataAccessor(ClassInstrumenter.this.id, ClassInstrumenter.this.className, probeCount, mv);
            mv.visitInsn(89);
            mv.visitFieldInsn(179, ClassInstrumenter.this.className, "$jacocoData", "[Z");
            return Math.max(size, 2);
        }
    }
}

