package de.uni_hildesheim.sse.trans.in;

/**
 * Will be thrown in case that a input model could not be parsed.
 * @author El-Sharkawy
 *
 */
@SuppressWarnings("serial")
public class ParserException extends Exception {
    
    /**
     * Description why the {@link ParserException} was thrown.
     * @author El-Sharkawy
     *
     */
    public static enum ParserExceptionType {
        /**
         * Input file contains a field, which is not supported by the Reader.
         */
        NOT_SUPPORTED_FIELD,
        
        /**
         * New/Not supported KConfig datatype, which is not handled by this program.
         */
        NOT_SUPPORTED_DATATYPE;
    }
    
    private ParserExceptionType description;
    
    /**
     * Sole constructor for this {@link ParserException}.
     * @param description Description why the {@link ParserException} was thrown.
     *     Must <b>not</b> be <tt>null</tt>.
     */
    public ParserException(ParserExceptionType description) {
        this.description = description;
    }

    /**
     * Getter for the description.
     * @return Description why the {@link ParserException} was thrown.
     */
    public ParserExceptionType getDescription() {
        return description;
    }
}
