package de.uni_hildesheim.sse.trans.in.rsf;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;

/**
 * Represents a condition read from a .rsf file.
 * 
 * @author Adam Krafczyk
 */
class RSFCondition {

    private String variable;
    private String condition;
    
    /**
     * Creates a condition with the given variable and condition as read from the .rsf file.
     * @param variable The name of the variable
     * @param condition The condition as read from the .rsf file
     */
    RSFCondition(String variable, String condition) {
        this.variable = variable;
        this.condition = condition;
    }
    
    /**
     * Returns this condition as a {@link ConstraintSyntaxTree}.
     * It will look like: (variable AND condition) OR (NOT variable AND NOT condition).
     * @return A {@link ConstraintSyntaxTree} representing this condition.
     */
    ConstraintSyntaxTree toConstraintSyntaxTree() {
        return null;
    }
    
}
