package de.uni_hildesheim.sse.trans.convert;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import de.uni_hildesheim.sse.model.varModel.AbstractVariable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.filter.ConstraintFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder.VisibilityType;
import de.uni_hildesheim.sse.model.varModel.filter.DeclrationInConstraintFinder;
import de.uni_hildesheim.sse.model.varModel.filter.FilterType;

/**
 * Checks a given model for unused variables (i.e. variables that are not used in constraints).
 * 
 * @author Adam Krafczyk
 */
public class UnusedVariableChecker {

    private Project model;
    
    /**
     * Creates a {@link UnusedVariableChecker} for the given project.
     * @param model The project to be checked by this checker
     */
    public UnusedVariableChecker(Project model) {
        this.model = model;
    }
    
    /**
     * Removes all unused variables (i.e. variables that are not used in constraints) from the project.
     * 
     * @return The number of removed variables.
     */
    public int removeUnusedVariables() {
        ConstraintFinder cFinder = new ConstraintFinder(model);
        DeclarationFinder varFinder = new DeclarationFinder(model, FilterType.ALL, null);
        
        List<AbstractVariable> varList = varFinder.getVariableDeclarations(VisibilityType.ALL);
        Set<AbstractVariable> varSet = new HashSet<AbstractVariable>(varList);
        
        List<Constraint> constraints = cFinder.getConstraints();
        for (int i = 0, n = constraints.size(); i < n; i++) {
            Constraint constraint = constraints.get(i);
            DeclrationInConstraintFinder finder = new DeclrationInConstraintFinder(constraint.getConsSyntax());
            Set<AbstractVariable> declarations = finder.getDeclarations();
            varSet.removeAll(declarations);
            
            /*
             *  Release constraint to deallocate memory.
             *  set(index, null) avoids Array.copy
             */
            constraints.set(i, null);
        }
        
        for (AbstractVariable var : varSet) {
            model.removeElement(var);
        }
        
        return varSet.size();
    }
    
}
