package de.uni_hildesheim.sse.trans.cli;

import java.io.File;

import de.uni_hildesheim.sse.trans.convert.OptimizationParameter;

/**
 * Arguments passed to this program.
 * @author El-Sharkawy
 *
 */
public class Arguments {

    private File inputFile;
    private File outputFile;
    private String comment;
    private String version;
    private boolean help;
    private OptimizationParameter optimizations;
    
    /**
     * Sole constructor for this class.
     * If no arguments are passed to this object, it will force to print out the help instead of model translation.
     */
    Arguments() {
        inputFile = null;
        outputFile = null;
        comment = null;
        version = null;
        help = true;
        optimizations = new OptimizationParameter();
    }
    
    /**
     * Getter for the source file.
     * @param inputFile the inputFile to set, must not be <tt>null</tt>.
     */
    void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    /**
     * Getter for the destination file.
     * @param outputFile the outputFile to set, must not be <tt>null</tt>.
     */
    void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    /**
     * Setter for an optional comment.
     * @param comment the comment to set
     */
    void setComment(String comment) {
        this.comment = comment;
    }

    /**
     * Setter for an optional version.
     * @param version the version to set
     */
    void setVersion(String version) {
        this.version = version;
    }

    /**
     * Specification whether the help shall be printed out.
     * @param help the help to set. If <tt>true</tt> the help will be printed out instead of translating the models.
     */
    void setHelp(boolean help) {
        this.help = help;
    }

    /**
     * Getter for the source file.
     * @return the inputFile
     */
    public File getInputFile() {
        return inputFile;
    }
    
    /**
     * Getter for the destination file.
     * @return the outputFile
     */
    public File getOutputFile() {
        return outputFile;
    }
    
    /**
     * An optional comment, which shall be added to the destination file.
     * @return the comment
     */
    public String getComment() {
        return comment;
    }
    
    /**
     * Optional specification of the read source version.
     * @return the version
     */
    public String getVersion() {
        return version;
    }
    
    /**
     * Specification whether the help should be printed.
     * @return the help If <tt>true</tt> only the help will be printed, otherwise the translation will be done.
     */
    public boolean isHelp() {
        return help;
    }
    
    /**
     * Returns the selected {@link OptimizationParameter}.
     * @return The selected {@link OptimizationParameter}, will not be <tt>null</tt>.
     */
    public OptimizationParameter getOptimizationParameter() {
        return optimizations;
    }
    
}
