package de.uni_hildesheim.sse.trans.convert;

/**
 * Data class for specification which optimizations ({@link ModelOptimizer}) shall be performed.
 * @author El-Sharkawy
 *
 */
public class OptimizationParameter {
    
    private boolean eleminateConstants;
    private boolean removeUnusedVariables;
    private boolean removeDuplicatedConstraints;
    
    /**
     * Default constructor, will disable all optimizations.
     */
    public OptimizationParameter() {
        this(false);
    }
    
    /**
     * Constructor for specifying, whether all optimizations shall be applied or none.
     * @param allOn <tt>true</tt> all optimizations will be turned on, otherwise all optimizations will be turned off.
     */
    public OptimizationParameter(boolean allOn) {
        eleminateConstants = allOn;
        removeUnusedVariables = allOn;
        removeDuplicatedConstraints = allOn;
    }

    /**
     * Specification whether Constants shall be removed ({@link ModelOptimizer#handleConstantVariables()}.
     * @return <tt>true</tt> constants will be removed.
     */
    public boolean eleminateConstants() {
        return eleminateConstants;
    }
    
    /**
     * Specification whether Constants shall be removed ({@link ModelOptimizer#handleConstantVariables()}.
     * @param eleminateConstants <tt>true</tt> constants will be removed.
     */
    public void setEleminateConstants(boolean eleminateConstants) {
        this.eleminateConstants = eleminateConstants;
    }
    
    /**
     * Specification whether unused variables shall be removed ({@link ModelOptimizer#removeUnusedVariables()}.
     * @return <tt>true</tt> unused variables will be removed.
     */
    public boolean removeUnusedVariables() {
        return removeUnusedVariables;
    }
    
    /**
     * Specification whether unused variables shall be removed ({@link ModelOptimizer#removeUnusedVariables()}.
     * @param removeUnusedVariables <tt>true</tt> unused variables will be removed.
     */
    public void setRemoveUnusedVariables(boolean removeUnusedVariables) {
        this.removeUnusedVariables = removeUnusedVariables;
    }
    
    /**
     * Specification whether duplicated constraints shall be removed
     * ({@link ModelOptimizer#removeDuplicatedConstraints()}.
     * @return <tt>true</tt> duplicated constraints will be removed.
     */
    public boolean removeDuplicatedConstraints() {
        return removeDuplicatedConstraints;
    }
    
    /**
     *  Specification whether duplicated constraints shall be removed
     * ({@link ModelOptimizer#removeDuplicatedConstraints()}.
     * @param removeDuplicatedConstraints <tt>true</tt> duplicated constraints will be removed.
     */
    public void setRemoveDuplicatedConstraints(boolean removeDuplicatedConstraints) {
        this.removeDuplicatedConstraints = removeDuplicatedConstraints;
    }
    
    /**
     * Returns whether at least one option was set to <tt>true</tt>.
     * @return <tt>true</tt> if at least one option was set to <tt>true</tt>.
     */
    public boolean hasAtLeastOneOption() {
        return eleminateConstants || removeDuplicatedConstraints || removeUnusedVariables;
    }
}
