package de.uni_hildesheim.sse.trans;

import java.io.File;

import de.uni_hildesheim.sse.trans.cli.Arguments;
import de.uni_hildesheim.sse.trans.cli.ArgumentsParser;
import de.uni_hildesheim.sse.trans.in.InputType;
import de.uni_hildesheim.sse.trans.out.OutputType;
import de.uni_hildesheim.sse.utils.logger.AdvancedJavaLogger;
import de.uni_hildesheim.sse.utils.logger.EASyLoggerFactory;
import de.uni_hildesheim.sse.utils.logger.LoggingLevel;

/**
 * Starting point for the whole translation.
 * @author El-Sharkawy
 *
 */
public class Main {
    
    public static final String ID = "de.uni-hildesheim.sse.modeltranslator";
    
    static {
        EASyLoggerFactory.INSTANCE.setLogger(new AdvancedJavaLogger());
        EASyLoggerFactory.INSTANCE.setLoggingLevel(LoggingLevel.INFO);
    }

    /**
     * Main-Method of this translator.
     * @param args Pass no arguments to this program to get a helpful message.
     */
    public static void main(String[] args) {
        Arguments arguments = ArgumentsParser.parse(args);
        
        if (arguments.isHelp()) {
            ArgumentsParser.printHelp();
        } else {
            File sourceFile = arguments.getInputFile();
            File destFile = arguments.getOutputFile();
            OutputType resultType = destFile.getName().endsWith(".ivml") ? OutputType.IVML : OutputType.DIMCAS;
            InputType sourceType = sourceFile.getName().endsWith(".model") ? InputType.MODEL : InputType.RSF;
            ModelTranslator.translate(sourceFile, destFile, sourceType, resultType, arguments.getComment(),
                arguments.getVersion(), arguments.getOptimizationParameter());
        }
    }
}
