package de.uni_hildesheim.sse.trans.in.rsf;

import java.util.ArrayList;
import java.util.List;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.cst.VariablePool;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;
import de.uni_hildesheim.sse.trans.in.AbstractReader;

/**
 * Contains a Choice and the ChoiceItems.
 * 
 * @author Adam Krafczyk
 */
class RSFChoice {

    private static VariablePool varPool = new VariablePool();
    
    private String choiceName;
    private List<String> choiceItems;
    
    /**
     * Creates a new Choice with no ChoiceItems.
     * @param choiceName The name of the Choice.
     */
    RSFChoice(String choiceName) {
        this.choiceName = choiceName;
        choiceItems = new ArrayList<String>();
    }
    
    /**
     * Adds a ChoiceItem to the Choice.
     * @param name The name of the ChoiceItem.
     */
    void addChoiceItem(String name) {
        choiceItems.add(name);
    }
    
    /**
     * Creates a {@link ConstraintSyntaxTree}s to assure that only one ChoiceItem is selected.
     * @param reader A reader to get variable declarations from.
     * @return An array of {@link ConstraintSyntaxTree}s.
     */
    ConstraintSyntaxTree[] getBooleanConstraintSyntaxTree(AbstractReader reader) {
        // Create choiceItems.size() Constraints with all choiceItems OR'd together and 1 negated each.
        // Also contains NOT choiceName since the choice only applies if choiceName is true
        
        ConstraintSyntaxTree[] trees = new ConstraintSyntaxTree[choiceItems.size()];
        Variable choiceVar = varPool.obtainVariable(reader.getVariable(choiceName));
        
        for (int i = 0; i < trees.length; i++) {
            
            trees[i] = new OCLFeatureCall(choiceVar, OclKeyWords.NOT);
            
            for (int j = 0; j < choiceItems.size(); j++) {
                Variable var = varPool.obtainVariable(reader.getVariable(choiceItems.get(j)));
                // variable #i should be negated
                if (j == i) {
                    trees[i] = new OCLFeatureCall(trees[i], OclKeyWords.OR,
                            new OCLFeatureCall(var, OclKeyWords.NOT));
                } else {
                    trees[i] = new OCLFeatureCall(trees[i], OclKeyWords.OR, var);
                }
            }
            
        }
        
        return trees;
    }
    
}
