package de.uni_hildesheim.sse.trans.convert;

import java.util.Set;

import de.uni_hildesheim.sse.model.varModel.Constraint;

/**
 * 2-tuple of (constraint, used literals).
 * @author El-Sharkawy
 *
 */
class ConstraintContainer {
    private Constraint constraint;
    private Set<String> literals;
    
    /**
     * Sole constructor.
     * @param constraint The constraint to hold
     * @param literals the literals (positive/negative declarations) of the related constraint
     */
    ConstraintContainer(Constraint constraint, Set<String> literals) {
        this.constraint = constraint;
        this.literals = literals;
    }

    /**
     * Getter for the constraint.
     * @return The constraint
     */
    Constraint getConstraint() {
        return constraint;
    }
    
    /**
     * Getter for the literals.
     * @return The literals (positive/negative declarations) of the related constraint
     */
    Set<String> getLiterals() {
        return literals;
    }
}
