package de.uni_hildesheim.sse.trans.in;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

import org.junit.Before;
import org.junit.Test;

import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.persistency.IVMLWriter;
import de.uni_hildesheim.sse.trans.AllTests;

/**
 * Tests for {@link ModelReader}
 * @author El-Sharkawy
 *
 */
public class ModelReaderTest {
    
    private StringWriter sWriter;
    private IVMLWriter iWriter;
    
    /**
     * Creates the writer for parsing the created result (the {@link Project}.
     */
    @Before
    public void setUp() {
        sWriter = new StringWriter();
        iWriter = new IVMLWriter(sWriter);
    }

    @Test
    public void testRead() throws IOException {
        File modelFile = new File(AllTests.INPUT_FOLDER, "model.model");
        ModelReader reader = new ModelReader(modelFile);
        Project project = reader.read();
        
        project.accept(iWriter);
        System.out.println(sWriter);
    }

}
