package de.uni_hildesheim.sse.trans.in.rsf;

import java.util.ArrayList;
import java.util.List;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.datatypes.Enum;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;
import de.uni_hildesheim.sse.trans.in.AbstractReader;
import de.uni_hildesheim.sse.trans.in.ParserException;

/**
 * A condition to ensure that either VAR_MODULE or VAR is true.
 * 
 * @author Adam Krafczyk
 */
class RSFModuleCondition extends RSFCondition {

    private String variable;
    private String moduleVariable;
    
    /**
     * Creates a condition with the given variable and its module version.
     * @param variable The variable
     * @param moduleVariable The module version of the variable
     */
    RSFModuleCondition(String variable, String moduleVariable) {
        this.variable = variable;
        this.moduleVariable = moduleVariable;
    }
    
    @Override
    List<ConstraintSyntaxTree> toPureBooleanConstraintSyntaxTree(RSFReader reader) throws ParserException {
        Variable var = varPool.obtainVariable(reader.getVariable(variable));
        Variable moduleVar = varPool.obtainVariable(reader.getVariable(moduleVariable));
        
        OCLFeatureCall notVar = new OCLFeatureCall(var, OclKeyWords.NOT);
        OCLFeatureCall notModuleVar = new OCLFeatureCall(moduleVar, OclKeyWords.NOT);
        
        List<ConstraintSyntaxTree> list  = new ArrayList<ConstraintSyntaxTree>();
        list.add(new OCLFeatureCall(notVar, OclKeyWords.OR, notModuleVar));
        return list;
    }
    
    @Override
    ConstraintSyntaxTree toNotBooleanConstraintSyntaxTree(AbstractReader reader, Enum tristate) throws ParserException {
        // Shouldn't be called since there are not separate _MODULE variables in not boolean models
        return null;
    }

}
