package de.uni_hildesheim.sse.trans.in.rsf;

import java.util.ArrayList;
import java.util.List;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.cst.VariablePool;
import de.uni_hildesheim.sse.model.varModel.datatypes.Enum;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;
import de.uni_hildesheim.sse.trans.in.AbstractReader;
import de.uni_hildesheim.sse.trans.in.ParserException;

/**
 * Contains a Choice and the ChoiceItems.
 * {@link RSFChoice#toPureBooleanConstraintSyntaxTree(RSFReader)} assures, that only one variable of the choice is
 * selected.
 * 
 * @author Adam Krafczyk
 */
class RSFChoice extends RSFCondition {

    private static VariablePool varPool = new VariablePool();
    
    private RSFItem choiceItem;
    private List<RSFItem> choiceItems;
    
    /**
     * Creates a new Choice with no ChoiceItems.
     * @param choiceItem The name of the Choice.
     */
    RSFChoice(RSFItem choiceItem) {
        this.choiceItem = choiceItem;
        choiceItems = new ArrayList<RSFItem>();
    }
    
    /**
     * Adds a ChoiceItem to the Choice.
     * @param item The name of the ChoiceItem.
     */
    void addChoiceItem(RSFItem item) {
        choiceItems.add(item);
    }
    
    @Override
    List<ConstraintSyntaxTree> toPureBooleanConstraintSyntaxTree(RSFReader reader) throws ParserException {
        //ConstraintSyntaxTree[] trees = new ConstraintSyntaxTree[choiceItems.size()];
        List<ConstraintSyntaxTree> trees = new ArrayList<ConstraintSyntaxTree>();
        
        ConstraintSyntaxTree notChoiceVar = getUnselectedVariable(choiceItem, reader);
        
        // Create one tree with all variables OR'd together
        ConstraintSyntaxTree allItemsTree = notChoiceVar;
        
        // And for each unique combination of choiceItems:
        for (int i = 0; i < choiceItems.size(); i++) {
            
            Variable var1 = varPool.obtainVariable(reader.getVariable(choiceItems.get(i).getName()));
            ConstraintSyntaxTree notVar1 = getUnselectedVariable(choiceItems.get(i), reader);
            
            for (int j = i + 1; j < choiceItems.size(); j++) {
                // Add the 2 variables negated and OR'd together:
                ConstraintSyntaxTree notVar2 = getUnselectedVariable(choiceItems.get(j), reader);
                
                OCLFeatureCall call = new OCLFeatureCall(notVar1, OclKeyWords.OR, notVar2);
                trees.add(new OCLFeatureCall(notChoiceVar, OclKeyWords.OR, call));
            }
            
            allItemsTree = new OCLFeatureCall(allItemsTree, OclKeyWords.OR, var1);
        }
        
        trees.add(allItemsTree);
        
        return trees;
    }

    @Override
    ConstraintSyntaxTree toNotBooleanConstraintSyntaxTree(AbstractReader reader, Enum tristate) throws ParserException {
        // TODO implement
        return null;
    }
    
}
