package out;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.uni_hildesheim.sse.model.confModel.AssignmentState;
import de.uni_hildesheim.sse.model.confModel.Configuration;
import de.uni_hildesheim.sse.model.confModel.ConfigurationException;
import de.uni_hildesheim.sse.model.confModel.IDecisionVariable;
import de.uni_hildesheim.sse.model.cstEvaluation.EvaluationVisitor;
import de.uni_hildesheim.sse.model.varModel.AbstractVariable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.filter.ConstraintFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder.VisibilityType;
import de.uni_hildesheim.sse.model.varModel.filter.DeclrationInConstraintFinder;
import de.uni_hildesheim.sse.model.varModel.filter.FilterType;
import de.uni_hildesheim.sse.model.varModel.values.BooleanValue;

public class DimacsWriter {

    private Project project;
    private Map<String, Integer> variables;
    
    public DimacsWriter(Project project) {
        this.project = project;
        variables = new HashMap<String, Integer>();
    }
    
    public void write(PrintStream out) throws IOException {
        DeclarationFinder declarationFinder = new DeclarationFinder(project, FilterType.ALL, null);
        List<AbstractVariable> variableDeclarations = declarationFinder.getVariableDeclarations(VisibilityType.ALL);
        Collections.sort(variableDeclarations, new Comparator<AbstractVariable>() {
            public int compare(AbstractVariable o1, AbstractVariable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        
        Integer i = 1;
        for (AbstractVariable variable : variableDeclarations) {
            variables.put(variable.getName(), i++);
            out.print("c ");
            out.print(i.toString());
            out.print(" ");
            out.print(variable.getName());
            out.println();
        }
        
        // TODO print(p CNF numVars numConstrains);
        
        ConstraintFinder constraintFinder = new ConstraintFinder(project);
        
        Configuration config = new Configuration(project);
        EvaluationVisitor evalVisitor = new EvaluationVisitor();
        
        int anz = 0;
        for (Constraint constraint : constraintFinder.getConstraints()) {
            anz++;
            if (anz > 100) {
                break;
            }
            
            DeclrationInConstraintFinder varFinder = new DeclrationInConstraintFinder(constraint.getConsSyntax());
            
            Object[] vars = varFinder.getDeclarations().toArray();
            
            int bitmask = 0;
            for (int k = 0; k < Math.pow(2, vars.length); k++) {
                bitmask++;
                boolean[] values = new boolean[vars.length];
                for (int j = 0; j < vars.length; j++) {
                    IDecisionVariable decisionVar = config.getDecision((AbstractVariable) vars[j]);
                    try {
                        boolean bool = (bitmask & 1 << j) != 0;
                        values[j] = bool;
                        decisionVar.setValue(bool ? BooleanValue.TRUE : BooleanValue.FALSE, AssignmentState.ASSIGNED);
                    } catch (ConfigurationException e) {
                        e.printStackTrace();
                    }
                }
                
                boolean result = Math.random() >= 0.5; // TODO
                
                if (result) {
                    for (int j = 0; j < vars.length; j++) {
                        if (!values[j]) {
                            out.print("-");
                        }
                        out.print(variables.get(((AbstractVariable) vars[j]).getName()));
                        out.print(" ");
                    }
                    out.println("0");
                }
            }
            
            
            //out.print(constraint.toString());
            //out.println();
        }
        out.flush();
    }
    
}
