package de.uni_hildesheim.sse.trans.in;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;

import org.apache.commons.io.output.WriterOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.trans.AllTests;
import de.uni_hildesheim.sse.trans.out.DimacsWriter;

/**
 * Tests for {@link ModelReader}.
 * @author El-Sharkawy
 *
 */
public class ModelReaderTest {
    
    private StringWriter sWriter;
    //private IVMLWriter iWriter;
    
    /**
     * Creates the writer for parsing the created result (the {@link Project}.
     */
    @Before
    public void setUp() {
        sWriter = new StringWriter();
        //iWriter = new IVMLWriter(sWriter);
    }

    @Test
    public void testRead() throws IOException {
        File modelFile = new File(AllTests.INPUT_FOLDER, "model.model");
        ModelReader reader = new ModelReader(modelFile);
        Project project = reader.read();
        
        PrintStream writer = new PrintStream(new WriterOutputStream(sWriter));
        new DimacsWriter(project).write(writer);
        
        System.out.println(sWriter);
        
        //project.accept(iWriter);
        //System.out.println(sWriter);
    }
    
    @Test
    public void testParseLine() throws IOException {
        File modelFile = new File(AllTests.INPUT_FOLDER, "model.model");
        ModelReader reader = new ModelReader(modelFile);
        
        try {
            //reader.parseLine("(!def(3C515_MODULE)|def(MODULES))");
            reader.parseLine("((def(TR)&def(PCI)&def(NETDEVICES))|(def(NETDEVICES)&((def(TR)&def(PCI))|"
                + "(def(PCI)&(def(TR)|def(TR_MODULE)))))|def(MODULES)|!def(3C359))", 0);
        } catch (Exception e) {
            e.printStackTrace();
            Assert.fail(e.toString());
        }
    }

}
