package de.uni_hildesheim.sse.trans.convert;

import java.util.List;

import de.uni_hildesheim.sse.model.varModel.Constraint;

/**
 * Strategy for converting a boolean constraint into CNF form.
 * @author El-Sharkawy
 *
 */
public interface ICNFConvertStrategy {

    /**
     * Converts boolean formula into a CNF formula, which may consists of multiple disjunction terms.
     * @param constraint The boolean constraint, which shall be converted.
     * @return A list of constraints expressing the same formula.
     */
    public List<Constraint> convert(Constraint constraint);
}
