package de.uni_hildesheim.sse.trans;

import java.io.File;

import de.uni_hildesheim.sse.trans.cli.Arguments;
import de.uni_hildesheim.sse.trans.cli.ArgumentsParser;
import de.uni_hildesheim.sse.trans.in.InputType;
import de.uni_hildesheim.sse.trans.out.OutputType;

/**
 * Starting point for the whole translation.
 * @author El-Sharkawy
 *
 */
public class Main {

    /**
     * Main-Method of this translator.
     * @param args Pass no arguments to this program to get a helpful message.
     */
    public static void main(String[] args) {
        Arguments arguments = ArgumentsParser.parse(args);
        
        if (arguments.isHelp()) {
            ArgumentsParser.printHelp();
        } else {
            File destFile = arguments.getOutputFile();
            OutputType resultType = destFile.getName().endsWith(".ivml") ? OutputType.IVML : OutputType.DIMCAS;
            ModelTranslator.translate(arguments.getInputFile(), destFile, InputType.MODEL,
                resultType, arguments.getComment(), arguments.getVersion());
        }
    }
}
