package de.uni_hildesheim.sse.trans.convert;

import java.util.Set;

import de.uni_hildesheim.sse.model.cst.CSTSemanticException;
import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.varModel.AbstractVariable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.filter.DeclrationInConstraintFinder;
import de.uni_hildesheim.sse.trans.Bundle;
import de.uni_hildesheim.sse.utils.logger.EASyLoggerFactory;
import de.uni_hildesheim.sse.utils.logger.EASyLoggerFactory.EASyLogger;

/**
 * Converts a boolean formula in a list of disjunction terms by means of
 * <a href="http://de.wikipedia.org/wiki/Konjunktive_Normalform#Beispiel_f.C3.BCr_die_Bildung">max terms</a>.
 * @author El-Sharkawy
 *
 */
public class MaxTermConverter implements ICNFConvertStrategy {
    private static final EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(MaxTermConverter.class, Bundle.ID);

    private Project project;
    
    @Override
    public void convert(Constraint constraint) {
        project = (Project) constraint.getTopLevelParent();
        ConstraintSyntaxTree originalConstraint = constraint.getConsSyntax();
        DeclrationInConstraintFinder finder = new DeclrationInConstraintFinder(originalConstraint);
        Set<AbstractVariable> declarations = finder.getDeclarations();
        System.out.println(declarations.size());
    }

    /**
     * Adds the given constraint to the project.
     * @param cst The constraint to add.
     */
    private void addConstraint(ConstraintSyntaxTree cst) {
        Constraint constraint = new Constraint(project);
        try {
            constraint.setConsSyntax(cst);
        } catch (CSTSemanticException e) {
            LOGGER.exception(e);
        }
        
        project.add(constraint);
    }
}
