/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.instr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jacoco.asm.ClassReader;
import org.jacoco.asm.ClassVisitor;
import org.jacoco.asm.ClassWriter;
import org.jacoco.core.internal.ContentTypeDetector;
import org.jacoco.core.internal.Pack200Streams;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.jacoco.core.internal.instr.ClassInstrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;

public class Instrumenter {
    private final IExecutionDataAccessorGenerator accessGenerator;

    public Instrumenter(IExecutionDataAccessorGenerator runtime) {
        this.accessGenerator = runtime;
    }

    private ClassVisitor createInstrumentingVisitor(long classid, ClassVisitor cv) {
        return new ClassProbesAdapter(new ClassInstrumenter(classid, this.accessGenerator, cv), true);
    }

    public byte[] instrument(ClassReader reader) {
        ClassWriter writer = new ClassWriter(reader, 0);
        ClassVisitor visitor = this.createInstrumentingVisitor(CRC64.checksum(reader.b), writer);
        reader.accept(visitor, 8);
        return writer.toByteArray();
    }

    public byte[] instrument(byte[] buffer, String name) throws IOException {
        try {
            return this.instrument(new ClassReader(buffer));
        }
        catch (RuntimeException e) {
            throw this.instrumentError(name, e);
        }
    }

    public byte[] instrument(InputStream input, String name) throws IOException {
        try {
            return this.instrument(new ClassReader(input));
        }
        catch (RuntimeException e) {
            throw this.instrumentError(name, e);
        }
    }

    public void instrument(InputStream input, OutputStream output, String name) throws IOException {
        try {
            output.write(this.instrument(new ClassReader(input)));
        }
        catch (RuntimeException e) {
            throw this.instrumentError(name, e);
        }
    }

    private IOException instrumentError(String name, RuntimeException cause) {
        IOException ex = new IOException(String.format("Error while instrumenting class %s.", name));
        ex.initCause(cause);
        return ex;
    }

    public int instrumentAll(InputStream input, OutputStream output, String name) throws IOException {
        ContentTypeDetector detector = new ContentTypeDetector(input);
        switch (detector.getType()) {
            case -889275714: {
                this.instrument(detector.getInputStream(), output, name);
                return 1;
            }
            case 1347093252: {
                return this.instrumentZip(detector.getInputStream(), output, name);
            }
            case 529203200: {
                return this.instrumentGzip(detector.getInputStream(), output, name);
            }
            case -889270259: {
                return this.instrumentPack200(detector.getInputStream(), output, name);
            }
        }
        this.copy(detector.getInputStream(), output);
        return 0;
    }

    private int instrumentZip(InputStream input, OutputStream output, String name) throws IOException {
        ZipEntry entry;
        ZipInputStream zipin = new ZipInputStream(input);
        ZipOutputStream zipout = new ZipOutputStream(output);
        int count = 0;
        while ((entry = zipin.getNextEntry()) != null) {
            zipout.putNextEntry(new ZipEntry(entry.getName()));
            count += this.instrumentAll(zipin, zipout, name + "@" + entry.getName());
            zipout.closeEntry();
        }
        zipout.finish();
        return count;
    }

    private int instrumentGzip(InputStream input, OutputStream output, String name) throws IOException {
        GZIPOutputStream gzout = new GZIPOutputStream(output);
        int count = this.instrumentAll(new GZIPInputStream(input), gzout, name);
        gzout.finish();
        return count;
    }

    private int instrumentPack200(InputStream input, OutputStream output, String name) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int count = this.instrumentAll(Pack200Streams.unpack(input), buffer, name);
        Pack200Streams.pack(buffer.toByteArray(), output);
        return count;
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }
}

