package de.uni_hildesheim.sse.trans.convert;

import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.CSTSemanticException;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Parenthesis;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;
import de.uni_hildesheim.sse.model.varModel.filter.ConstraintFinder;

/**
 * Tests the {@link MaxTermConverter}.
 * 
 * @author Adam Krafczyk
 */
public class MaxTermConverterTest {

    /**
     * Tests the convert method.
     */
    @Test
    public void testConvert() {
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        
        Variable varB = new Variable(declB);
        OCLFeatureCall notB = new OCLFeatureCall(varB, OclKeyWords.NOT);
        OCLFeatureCall termA = new OCLFeatureCall(new Variable(declA), OclKeyWords.OR, varB);
        OCLFeatureCall termB = new OCLFeatureCall(new Variable(declC), OclKeyWords.OR, notB);
        Parenthesis parenthesis = new Parenthesis(termB);
        OCLFeatureCall completeTerm = new OCLFeatureCall(termA, OclKeyWords.AND, parenthesis);
        
        // (a OR b) AND (c OR !b)
        /*
         * a b c  r
         * 0 0 0  0
         * 1 0 0  1
         * 0 1 0  0
         * 1 1 0  0
         * 0 0 1  0
         * 1 0 1  1
         * 0 1 1  1
         * 1 1 1  1
         */
        // (a OR b OR c) AND (a OR !b OR c) AND (!a OR !b OR c) AND (a OR b OR !c)
        
        Project testProject = new Project("TestProject");
        Constraint constraint = new Constraint(testProject);
        try {
            constraint.setConsSyntax(completeTerm);
        } catch (CSTSemanticException e) {
            Assert.fail(e.getMessage());
        }
        
        new MaxTermConverter().convert(constraint);
        
        ConstraintFinder finder = new ConstraintFinder(testProject);
        /*DebugConstraintTreeVisitor visitor = new DebugConstraintTreeVisitor(System.out);
        for (Constraint c : finder.getConstraints()) {
            c.getConsSyntax().accept(visitor);
        }*/
        Assert.assertEquals(4, finder.getConstraints().size());
    }

}
