package de.uni_hildesheim.sse.trans.out;

import java.io.StringWriter;

import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.CSTSemanticException;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.IvmlKeyWords;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;

/**
 * Tests the {@link DimacsWriterTest} class.
 * 
 * @author Adam Krafczyk
 */
public class DimacsWriterTest {

    /**
     * Tests the write method.
     */
    @Test
    public void testWrite() {
        Project project = new Project("testModel");
        
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        
        project.add(declA);
        project.add(declB);
        project.add(declC);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        Variable varC = new Variable(declC);
        
        OCLFeatureCall termA1 = new OCLFeatureCall(varA, OclKeyWords.OR, new OCLFeatureCall(varB, OclKeyWords.NOT));
        OCLFeatureCall completeTerm1 = new OCLFeatureCall(termA1, OclKeyWords.OR, varC);
        
        OCLFeatureCall termA2 = new OCLFeatureCall(new OCLFeatureCall(varA, OclKeyWords.NOT), OclKeyWords.OR, varB);
        OCLFeatureCall completeTerm2 = new OCLFeatureCall(termA2, OclKeyWords.OR,
                new OCLFeatureCall(varC, OclKeyWords.NOT));
        
        Constraint constraint1 = null;
        Constraint constraint2 = null;
        try {
            constraint1 = new Constraint(completeTerm1, project);
            constraint2 = new Constraint(completeTerm2, project);
        } catch (CSTSemanticException e) {
            // Can't happen...
            Assert.fail();
        }
        project.add(constraint1);
        project.add(constraint2);
        
        StringWriter stringWriter = new StringWriter();
        DimacsWriter writer = new DimacsWriter(project, stringWriter);
        writer.write("A test-file", "1.0");
        //System.out.println(stringWriter.toString());
        
        Assert.assertEquals("c A test-file" + IvmlKeyWords.LINEFEED
            + "c Version 1.0" + IvmlKeyWords.LINEFEED
            + "c 1 a" + IvmlKeyWords.LINEFEED
            + "c 2 b" + IvmlKeyWords.LINEFEED
            + "c 3 c" + IvmlKeyWords.LINEFEED
            + "p CNF 3 2" + IvmlKeyWords.LINEFEED
            + "3 -2 1 0" + IvmlKeyWords.LINEFEED
            + "-3 2 -1 0" + IvmlKeyWords.LINEFEED, stringWriter.toString());
    }
    
}
