package de.uni_hildesheim.sse.trans.convert;

import java.util.List;

import de.uni_hildesheim.sse.model.varModel.AbstractVariable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.filter.ConstraintFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder;
import de.uni_hildesheim.sse.model.varModel.filter.FilterType;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder.VisibilityType;

/**
 * Converts a Boolean {@link Project} into CNF form.
 * @author El-Sharkawy
 *
 */
public class CNFConverter {
    
    /**
     * Converts a Boolean {@link Project} into CNF form.
     * @param project A Boolean {@link Project} containing only constraints with AND, OR, and NOT operations.
     * @param converter A Strategy which is able to convert boolean formulas into CNF form.
     */
    public static void convert(Project project, ICNFConvertStrategy converter) {
        // Store complete content of project (imports are not used in this project).
        DeclarationFinder declfinder = new DeclarationFinder(project, FilterType.ALL, null);
        ConstraintFinder constFinder = new ConstraintFinder(project);
        
        // Clear old content
        project.clear();
        
        // 1. re-add Declarations
        List<AbstractVariable> declarations = declfinder.getVariableDeclarations(VisibilityType.ALL);
        for (AbstractVariable declaration : declarations) {
            project.add(declaration);
        }
        declfinder = null;
        declarations = null;
        
        // 2. Convert the constraints
        List<Constraint> constraints = constFinder.getConstraints();
        for (int i = 0, n = constraints.size(); i < n; i++) {
            Constraint constraint = constraints.get(i);
            DisjunctionChecker checker = new DisjunctionChecker(constraint);
            if (checker.isDisjunctionTerm()) {
                project.add(constraint);
            } else {
                converter.convert(constraint);
                if (i % 100 == 0) {
                    System.out.println("Progress: " + i);
                }
            }
            /*
             *  Release constraint to deallocate memory.
             *  set(index, null) avoids Array.copy
             */
            constraints.set(i, null);
        }
    }
    
}
