package de.uni_hildesheim.sse.trans.in.rsf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.trans.in.AbstractReader;

/**
 * This reader reads <tt>*.rsf</tt> files, as they are created by the patched version of
 * <a href="https://github.com/ckaestne/undertaker">Undertaker's Dumpconf</a> tool.
 * These models must be pure boolean already.
 * @author El-Sharkawy
 *
 */
public class RSFReader extends AbstractReader {
    
    private Map<String, RSFItem> items;
    
    /**
     * Loads a <a href="https://github.com/ckaestne/undertaker">Undertaker's Dumpconf</a> rsf file.
     * @param rsfFile A RSF file, created by Undertaker's dumpconf
     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file,
     * or for some other reason cannot be opened for reading.
     */
    public RSFReader(File rsfFile) throws FileNotFoundException {
        super(rsfFile);
        items = new HashMap<String, RSFItem>();
    }
    
    /**
     * Returns the specifies {@link RSFItem}, for the given name.
     * @param name The name of the KConfig item.
     * @return The {@link RSFItem} representing the KConfig item.
     */
    private RSFItem getItem(String name) {
        RSFItem item = items.get(name);
        if (null == item) {
            item = new RSFItem(name);
            items.put(name, item);
        }
        
        return item;
    }

    @Override
    public Project read() throws IOException {
        readItems();
        return getModel();
    }

    /**
     * First step of the translation, reads the items of the RSF file.
     * @throws IOException If an I/O error occurs
     */
    private void readItems() throws IOException {
        BufferedReader reader = getReader();
        String line;
        while ((line = reader.readLine()) != null) {
            // Skip lines starting with a #
            if (line.charAt(0) != '#') {
                String[] rows = line.split("\t");
                String itemName = rows[1];
                System.out.println(itemName);
                RSFItem item = getItem(itemName);
            }
        }
    }
}
