package de.uni_hildesheim.sse.trans.in.rsf;

/**
 * Datatype of a KConfig variable inside the
 * KConfig files (i.e. rsf files).
 * @author El-Sharkawy
 *
 */
public enum Datatype {
    BOOLEAN,
    TRISTATE,
    STRING,
    INTEGER,
    HEX;
    
    /**
     * Returns the {@link Datatype} for the given string representation.
     * @param type Maybe in small letters
     * @return Returns the related {@link Datatype} represented by <tt>type</tt> or <tt>null</tt>.
     */
    public static Datatype getDatatype(String type) {
        return valueOf(type.toUpperCase());
    }
}
