package de.uni_hildesheim.sse.trans.in.rsf;

/**
 * All information items of one KConfig variable, read out of a RSF file.
 * @author El-Sharkawy
 *
 */
class RSFItem {
    private String name;
    private Datatype type;
    
    /**
     * Sole constructor for this datatype.
     * @param name The name of the KConfig variable.O
     */
    RSFItem(String name) {
        this.name = name;
    }
   
    /**
     * Getter for the name of the {@link RSFItem}.
     * @return The name of this item.
     */
    public String getName() {
        return name;
    }
    
    /**
    * Setter for the {@link Datatype}.
    * @param type The Datatype of the item, maybe in small letters.
    */
    public void setDatatype(String type) {
        this.type = Datatype.getDatatype(type); 
    }

    /**
     * Getter for the Datatype of the variable.
     * @return The Datatype of the item.
     * @return
     */
    public Datatype getDatatype() {
        return type;
    }
}
