package de.uni_hildesheim.sse.trans.in.rsf;

import java.io.File;
import java.io.IOException;

import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.DebugConstraintTreeVisitor;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.filter.ConstraintFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder;
import de.uni_hildesheim.sse.model.varModel.filter.DeclarationFinder.VisibilityType;
import de.uni_hildesheim.sse.model.varModel.filter.FilterType;
import de.uni_hildesheim.sse.trans.AllTests;
import de.uni_hildesheim.sse.trans.in.ParserException;

/**
 * Tests for {@link RSFReader}.
 * 
 * @author Adam Krafczyk
 */
public class RSFReaderTest {

    /**
     * Tests the read method of the {@link RSFReader}.
     * @throws IOException when the {@link RSFReader} throws an {@link IOException}.
     * @throws ParserException  when the {@link RSFReader} throws an {@link ParserException}.
     */
    @Test
    public void testRead() throws IOException, ParserException {
        File modelFile = new File(AllTests.INPUT_FOLDER, "testModel.rsf");
        RSFReader reader = new RSFReader(modelFile);
        
        Project project = reader.read();
        
        ConstraintFinder cFinder = new ConstraintFinder(project);
        Assert.assertEquals(4, cFinder.getConstraints().size());
        
//        for (Constraint c : cFinder.getConstraints()) {
//            c.getConsSyntax().accept(new DebugConstraintTreeVisitor());
//        }
        
        DeclarationFinder varFinder = new DeclarationFinder(project, FilterType.ALL, null);
        Assert.assertEquals(4, varFinder.getVariableDeclarations(VisibilityType.ALL).size());
    }
    
}
