package de.uni_hildesheim.sse.trans.convert;

import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.CSTSemanticException;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;

/**
 * Tests the {@link UnusedVariableChecker}.
 * 
 * @author Adam Krafczyk
 */
public class UnusedVariableCheckerTest {

    /**
     * Tests the removeUnusedVariables() method.
     * 
     * @throws CSTSemanticException can't happen.
     */
    @Test
    public void testRemoveUnusedVariables() throws CSTSemanticException {
        Project model = new Project("TestModel");
        
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        DecisionVariableDeclaration declD = new DecisionVariableDeclaration("d", BooleanType.TYPE, null);
        
        model.add(declA);
        model.add(declB);
        model.add(declC);
        model.add(declD);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        
        OCLFeatureCall term = new OCLFeatureCall(varA, OclKeyWords.OR, varB);
        
        Constraint constraint = new Constraint(model);
        constraint.setConsSyntax(term);
        model.add(constraint);
        
        UnusedVariableChecker checker = new UnusedVariableChecker(model);
        Assert.assertEquals(2, checker.removeUnusedVariables());
    }
    
}
