package de.uni_hildesheim.sse.trans.convert;

import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.CSTSemanticException;
import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.Constraint;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;
import de.uni_hildesheim.sse.model.varModel.filter.ConstraintFinder;

/**
 * Tests the {@link ModelOptimizer}.
 * 
 * @author Adam Krafczyk
 */
public class ModelOptimizerTest {

    /**
     * Tests the removeUnusedVariables() method.
     * 
     * @throws CSTSemanticException can't happen.
     */
    @Test
    public void testRemoveUnusedVariables() throws CSTSemanticException {
        Project model = new Project("TestModel");
        
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        DecisionVariableDeclaration declD = new DecisionVariableDeclaration("d", BooleanType.TYPE, null);
        
        model.add(declA);
        model.add(declB);
        model.add(declC);
        model.add(declD);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        
        OCLFeatureCall term = new OCLFeatureCall(varA, OclKeyWords.OR, varB);
        
        Constraint constraint = new Constraint(model);
        constraint.setConsSyntax(term);
        model.add(constraint);
        
        ModelOptimizer optimizer = new ModelOptimizer(model);
        Assert.assertEquals(2, optimizer.removeUnusedVariables());
    }
    
    /**
     * Tests the handleConstantVariables() method.
     * 
     * @throws CSTSemanticException can't happen.
     */
    @Test
    public void testHandleConstantVariables() throws CSTSemanticException {
        Project model = new Project("TestModel");
        
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        DecisionVariableDeclaration declD = new DecisionVariableDeclaration("d", BooleanType.TYPE, null);
        
        model.add(declA);
        model.add(declB);
        model.add(declC);
        model.add(declD);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        Variable varC = new Variable(declC);
        Variable varD = new Variable(declD);
        
        ConstraintSyntaxTree[] terms = new ConstraintSyntaxTree[6];
        terms[0] = varA;
        terms[1] = new OCLFeatureCall(varA, OclKeyWords.OR, varB);
        terms[2] = new OCLFeatureCall(new OCLFeatureCall(varA, OclKeyWords.NOT), OclKeyWords.OR, varB);
        
        terms[3] = new OCLFeatureCall(varC, OclKeyWords.NOT);
        terms[4] = new OCLFeatureCall(terms[3], OclKeyWords.OR, varD);
        terms[5] = new OCLFeatureCall(varC, OclKeyWords.OR, varD);
        
        for (ConstraintSyntaxTree tree : terms) {
            Constraint constraint = new Constraint(model);
            constraint.setConsSyntax(tree);
            model.add(constraint);
        }
        
        ModelOptimizer optimizer = new ModelOptimizer(model);
        optimizer.handleConstantVariables();
        
        /*
         * terms [1] and [4] should be removed.
         */
        
        ConstraintFinder cFinder = new ConstraintFinder(model);
        Assert.assertEquals(4, cFinder.getConstraints().size());
    }
    
}
