package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for MipMqttOutput.
 * Generated by: EASy-Producer.
 */
public class MipMqttOutputImplSerializer implements Serializer<MipMqttOutputImpl> {

    private static final Json MAPPER = Json.createInstance(MipMqttOutput.class, MipMqttOutputImpl.class);

    static {
        MAPPER.defineOptionals(MipMqttOutputImpl.class, "mipraw_signal_clock", "mipraw_signal_data1", 
            "mipraw_signal_data2");
        MAPPER.handleIipDataClasses();
    }

    @Override
    public MipMqttOutputImpl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, MipMqttOutputImpl.class);
    }

    @Override
    public byte[] to(MipMqttOutputImpl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public MipMqttOutputImpl clone(MipMqttOutputImpl origin) throws IOException {
        return new MipMqttOutputImpl(origin);
    }

    @Override
    public Class<MipMqttOutputImpl> getType() {
        return MipMqttOutputImpl.class;
    }

}
