/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import iip.datatypes.KRec13Anon;
import iip.datatypes.TurnstilePlcOutput;
import iip.impl.StateServiceImpl;
import java.io.InputStream;

public class StateService
extends StateServiceImpl {
    public Turnstile turnstile;

    protected StateService(ServiceKind kind) {
        super(kind);
    }

    protected StateService(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
    }

    protected StateService(YamlService yaml) {
        super(yaml);
    }

    protected StateService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    @Override
    public void processTurnstilePlcOutput(TurnstilePlcOutput data) {
    }

    @Override
    public void processKRec13Anon(KRec13Anon data) {
    }

    public StateService() {
        super(ServiceKind.SINK_SERVICE);
        this.turnstile = new Turnstile();
    }

    protected class Turnstile {
        private State currentState;
        private final State lockedState;
        private final State unlockedState;

        public Turnstile() {
            this.lockedState = new LockedState(this);
            this.currentState = this.unlockedState = new UnlockedState(this);
        }

        public void insertCoin() {
            this.currentState.insertCoin();
        }

        public void push() {
            this.currentState.push();
        }

        public State getLockedState() {
            return this.lockedState;
        }

        public void lockedAction() {
            System.out.println("Locked");
        }

        public void locked() {
            this.lockedAction();
        }

        public State getUnlockedState() {
            return this.unlockedState;
        }

        public void unlockedAction() {
            System.out.println("Unlocked");
        }

        public void unlocked() {
            this.unlockedAction();
        }

        public void setState(State state) {
            this.currentState = state;
        }
    }

    public class UnlockedState
    implements State {
        private final Turnstile context;

        public UnlockedState(Turnstile context) {
            this.context = context;
        }

        @Override
        public void insertCoin() {
            System.out.println("Inserting a coin in unlocked state -> no change");
            this.context.unlocked();
            this.context.setState(this.context.getUnlockedState());
        }

        @Override
        public void push() {
            System.out.println("Pushing in unlocked state -> push successful");
            this.context.locked();
            this.context.setState(this.context.getLockedState());
        }
    }

    public class LockedState
    implements State {
        private final Turnstile context;

        public LockedState(Turnstile context) {
            this.context = context;
        }

        @Override
        public void insertCoin() {
            System.out.println("inserting a coin in locked state -> unlocking the tile");
            this.context.unlocked();
            this.context.setState(this.context.getUnlockedState());
        }

        @Override
        public void push() {
            System.out.println("Pushing in locked state  -> no change");
            this.context.locked();
            this.context.setState(this.context.getLockedState());
        }
    }

    protected static interface State {
        public void insertCoin();

        public void push();
    }
}

