package iip.datatypes;

import de.iip_ecosphere.platform.support.ConfiguredName;
import de.iip_ecosphere.platform.support.Ignore;
import de.iip_ecosphere.platform.support.StringUtils;

import iip.datatypes.TurnstilePlcOutput;

/**
 * Implementation of the application data type TurnstilePlcOutput.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("TurnstilePlcOutput")
public class TurnstilePlcOutputImpl implements TurnstilePlcOutput {

    @ConfiguredName("insertCoin")
    private boolean insertCoin;
    @ConfiguredName("push")
    private boolean push;
    @ConfiguredName("money")
    private double money;
    @ConfiguredName("ready")
    private boolean ready;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public TurnstilePlcOutputImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public TurnstilePlcOutputImpl(TurnstilePlcOutput from) {
        this.insertCoin = from.getInsertCoin();
        this.push = from.getPush();
        this.money = from.getMoney();
        this.ready = from.getReady();
    }

    @Override
    @Ignore
    public boolean getInsertCoin() {
        return insertCoin;
    }

    @Override
    @Ignore
    public void setInsertCoin(boolean value) {
        this.insertCoin = value;
    }

    @Override
    @Ignore
    public boolean getPush() {
        return push;
    }

    @Override
    @Ignore
    public void setPush(boolean value) {
        this.push = value;
    }

    @Override
    @Ignore
    public double getMoney() {
        return money;
    }

    @Override
    @Ignore
    public void setMoney(double value) {
        this.money = value;
    }

    @Override
    @Ignore
    public boolean getReady() {
        return ready;
    }

    @Override
    @Ignore
    public void setReady(boolean value) {
        this.ready = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += Boolean.hashCode(getInsertCoin());
        hc += Boolean.hashCode(getPush());
        hc += Double.hashCode(getMoney());
        hc += Boolean.hashCode(getReady());
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof TurnstilePlcOutput) {
            TurnstilePlcOutput oth = (TurnstilePlcOutput) other;
            eq = true;
            eq &= getInsertCoin() == oth.getInsertCoin();
            eq &= getPush() == oth.getPush();
            eq &= getMoney() == oth.getMoney();
            eq &= getReady() == oth.getReady();
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
