package iip.impl;

import java.io.InputStream;

import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;

import iip.datatypes.KRec13Anon;
import iip.datatypes.TurnstilePlcOutput;
import iip.impl.StateServiceImpl;

/**
 * IIP-Ecosphere service with state machine for service 'StateService'.
 * Generated by: EASy-Producer.
 */
public class StateService extends StateServiceImpl {

    public Turnstile turnstile;

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param kind the service kind
     */
    protected StateService(ServiceKind kind) {
        super(kind);
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param serviceId the id of the service
     * @param kind the service kind
     */
    protected StateService(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
    }

    /**
     * Creates a service instance from YAML information.
     *
     * @param yaml the service information as read from YAML
     */
    protected StateService(YamlService yaml) {
        super(yaml);
    }

    /**
     * Creates a service instance from a service id and a YAML artifact.
     *
     * @param serviceId the id of the service
     * @param ymlFile the YML file containing the YAML artifact with the service descriptor
     */
    protected StateService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    @Override
    public void processTurnstilePlcOutput(TurnstilePlcOutput data) {
        // comment
        if (true /*data.getInsertCoin()*/) {
            // turnstile.insertCoin
        }
        if (true /*data.getPush()*/) {
            // turnstile.push
        }
        if (true /*data.getMoney()*/) {
            // turnstile.money
        }
        if (true /*data.getReady()*/) {
            // turnstile.ready
        }
        // events
        if (true /*insertCoin()*/) {
        }
        if (true /*data.insertCoin()*/) {
        }
        if (true /*data.money() == 3*/) {
        }
        if (true /*push()*/) {
        }
        if (true /*data.push()*/) {
        }
        if (true /*data.ready()*/) {
        }
    }

    @Override
    public void processKRec13Anon(KRec13Anon data) {
        // comment
    }

    protected interface State {

        void insertCoin();

        void push();

    }

    /**
     * NOWY KONSTRUCZOR
     */
    public StateService() {
        super(ServiceKind.SINK_SERVICE);
        this.turnstile = this.new Turnstile();
    }

    public class LockedState implements State {

        private final Turnstile context;

        /**
         * default constructor
         *
         * @param context 
         */
        public LockedState(Turnstile context) {
            this.context = context;
        }

        @Override
        public void insertCoin() {
            System.out.println("inserting a coin in locked state -> unlocking the tile");
            context.unlocked();
            context.setState(context.getUnlockedState());
        }

        @Override
        public void push() {
            System.out.println("Pushing in locked state  -> no change");
            context.locked();
            context.setState(context.getLockedState());
        }

    }

    public class UnlockedState implements State {

        private final Turnstile context;

        /**
         * default constructor
         *
         * @param context 
         */
        public UnlockedState(Turnstile context) {
            this.context = context;
        }

        @Override
        public void insertCoin() {
            System.out.println("Inserting a coin in unlocked state -> no change");
            context.unlocked();
            context.setState(context.getUnlockedState());
        }

        @Override
        public void push() {
            System.out.println("Pushing in unlocked state -> push successful");
            context.locked();
            context.setState(context.getLockedState());
        }

    }

    protected class Turnstile {

        private State currentState;
        private final State lockedState;
        private final State unlockedState;

        public Turnstile() {
            lockedState =  new LockedState(this);
            unlockedState =  new UnlockedState(this);
            currentState = unlockedState;
        }

        public void insertCoin() {
            currentState.insertCoin();
        }

        public void push() {
            currentState.push();
        }

        public State getLockedState() {
            return this.lockedState;
        }

        public void lockedAction() {
            System.out.println("Locked");
        }

        public void locked() {
            lockedAction();
        }

        public State getUnlockedState() {
            return this.unlockedState;
        }

        public void unlockedAction() {
            System.out.println("Unlocked");
        }

        public void unlocked() {
            unlockedAction();
        }

        public void setState(State state) {
            this.currentState = state;
        }

    }

}
