package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for KRec13.
 * Generated by: EASy-Producer.
 */
public class KRec13ImplSerializer implements Serializer<KRec13Impl> {

    private static final Json MAPPER = Json.createInstance(KRec13.class, KRec13Impl.class);

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public KRec13Impl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, KRec13Impl.class);
    }

    @Override
    public byte[] to(KRec13Impl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public KRec13Impl clone(KRec13Impl origin) throws IOException {
        return new KRec13Impl(origin);
    }

    @Override
    public Class<KRec13Impl> getType() {
        return KRec13Impl.class;
    }

}
