package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for TurnstilePlcOutput.
 * Generated by: EASy-Producer.
 */
public class TurnstilePlcOutputImplSerializer implements Serializer<TurnstilePlcOutputImpl> {

    private static final Json MAPPER = Json.createInstance(TurnstilePlcOutput.class, TurnstilePlcOutputImpl.class);

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public TurnstilePlcOutputImpl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, TurnstilePlcOutputImpl.class);
    }

    @Override
    public byte[] to(TurnstilePlcOutputImpl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public TurnstilePlcOutputImpl clone(TurnstilePlcOutputImpl origin) throws IOException {
        return new TurnstilePlcOutputImpl(origin);
    }

    @Override
    public Class<TurnstilePlcOutputImpl> getType() {
        return TurnstilePlcOutputImpl.class;
    }

}
