from datatypes.TurnstilePlcOutput import TurnstilePlcOutput
from datetime import datetime
from decimal import Decimal

class TurnstilePlcOutputImpl(TurnstilePlcOutput):
    """Implementation of the application data type TurnstilePlcOutput.
       Generated by: EASy-Producer."""

    # Mapped into properties without leading _ below resembling getter/setter

    _insertCoin: bool = None
    _push: bool = None
    _money: float = 0.0
    _ready: bool = None

    def getInsertCoin(self) -> bool:
        """Returns the value of insertCoin.
        Returns:
            bool
                the value of insertCoin
        """
        return self._insertCoin

    def getPush(self) -> bool:
        """Returns the value of push.
        Returns:
            bool
                the value of push
        """
        return self._push

    def getMoney(self) -> float:
        """Returns the value of money.
        Returns:
            float
                the value of money
        """
        return self._money

    def getReady(self) -> bool:
        """Returns the value of ready.
        Returns:
            bool
                the value of ready
        """
        return self._ready

    def setInsertCoin(self, v: bool):
        """Changes the value of insertCoin.
        Parameters:
            - v (bool) -- the new value of insertCoin
        """
        if "numpy" in str(type(v)):
            self._insertCoin = v.item()
        else:
            self._insertCoin = v

    def setPush(self, v: bool):
        """Changes the value of push.
        Parameters:
            - v (bool) -- the new value of push
        """
        if "numpy" in str(type(v)):
            self._push = v.item()
        else:
            self._push = v

    def setMoney(self, v: float):
        """Changes the value of money.
        Parameters:
            - v (float) -- the new value of money, may be of type float or the corresponding numpy type
        """
        if "numpy" in str(type(v)):
            self._money = v.item()
        else:
            self._money = v

    def setReady(self, v: bool):
        """Changes the value of ready.
        Parameters:
            - v (bool) -- the new value of ready
        """
        if "numpy" in str(type(v)):
            self._ready = v.item()
        else:
            self._ready = v

    # Indeed, there are 2.4 decorators for this, but for now we want to have all here: pythonic field access
    # backed by getter/setter and the ability to replace data classes by e.g. projecting or data enhancing
    # functionality (original idea of the "interfaces" with similar naming as in Java. It may be that the 
    # interfaces become superfluous due to the properties, but let's leave them in for now.
    insertCoin = property(getInsertCoin, setInsertCoin)
    push = property(getPush, setPush)
    money = property(getMoney, setMoney)
    ready = property(getReady, setReady)

