from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.KRec13Refined import KRec13Refined
from datatypes.KRec13RefinedImpl import KRec13RefinedImpl

class KRec13RefinedEncoder(JSONEncoder):
    """JSON encoder class for KRec13Refined.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class KRec13RefinedSerializer(TypeTranslatorToString):
    """JSON transport serializer for KRec13Refined.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["KRec13Refined"] = self
        Registry.types[KRec13Refined] = "KRec13Refined"
        Registry.serializers["KRec13RefinedImpl"] = self
        Registry.types[KRec13RefinedImpl] = "KRec13Refined"

    def readFrom(self, data: str) -> KRec13Refined:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            KRec13Refined
                the deserialized object
        """
        result = KRec13RefinedImpl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: KRec13Refined) -> str:
        """Turns an object into a String.
        Parameters:
            - source (KRec13Refined) -- the object
        Returns:
            str
                the serialized data string
        """
        return KRec13RefinedEncoder().encode(source).encode("UTF-8").decode()

    def readFromKRec13Refined(d: dict) -> KRec13Refined:
        """Turns a dict into an object of type KRec13Refined for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            KRec13Refined
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = KRec13RefinedImpl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToKRec13Refined(o: KRec13Refined) -> dict:
        """Turns an object of type KRec13Refined into a dict for serialization.
        Parameters:
            - o (KRec13Refined) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


KRec13RefinedSerializer()
