from json import JSONEncoder
import json
from datetime import datetime
from TypeTranslatorToString import TypeTranslatorToString
import Registry
from datatypes.SubmodelElementList import SubmodelElementList
from datatypes.SubmodelElementListImpl import SubmodelElementListImpl

class SubmodelElementListEncoder(JSONEncoder):
    """JSON encoder class for SubmodelElementList.
       Generated by: EASy-Producer."""

    def default(self, o):
        """Provides access to the attributes in o.
        Parameters:
            - o -- the object to serialize
        Returns:
            the attributes as dict
        """
        tmp = dict()
        for key in o.__dict__:
            k = key[1:]
            tmp[k] = o.__dict__[key]
        return tmp



class SubmodelElementListSerializer(TypeTranslatorToString):
    """JSON transport serializer for SubmodelElementList.
       Generated by: EASy-Producer."""

    def __init__(self):
        """Initializes the transformer."""
        Registry.serializers["SubmodelElementList"] = self
        Registry.types[SubmodelElementList] = "SubmodelElementList"
        Registry.serializers["SubmodelElementListImpl"] = self
        Registry.types[SubmodelElementListImpl] = "SubmodelElementList"

    def readFrom(self, data: str) -> SubmodelElementList:
        """Turns bytes into a String.
        Parameters:
            - data (str) -- the data string
        Returns:
            SubmodelElementList
                the deserialized object
        """
        result = SubmodelElementListImpl()
        jTmp = json.loads(data)
        tmp = dict()
        for key in jTmp:
            k = "_" + str(key)
            tmp[k] = jTmp[key]
        result.__dict__ = tmp
        return result

    def writeTo(self, source: SubmodelElementList) -> str:
        """Turns an object into a String.
        Parameters:
            - source (SubmodelElementList) -- the object
        Returns:
            str
                the serialized data string
        """
        return SubmodelElementListEncoder().encode(source).encode("UTF-8").decode()

    def readFromSubmodelElementList(d: dict) -> SubmodelElementList:
        """Turns a dict into an object of type SubmodelElementList for deep deserialization.
        Parameters:
            - d (dict) -- dict
        Returns:
            SubmodelElementList
                the object, may be None
        """
        if d is None:
            return None
        else:
            tmp = dict()
            result = SubmodelElementListImpl()
            for key in d:
                k = "_" + str(key)
                tmp[k] = d[key]
            result.__dict__ = tmp
            return result

    def writeToSubmodelElementList(o: SubmodelElementList) -> dict:
        """Turns an object of type SubmodelElementList into a dict for serialization.
        Parameters:
            - o (SubmodelElementList) -- the object, may be None
        Returns:
            dict
                the dict, may be None
        """
        if o is None:
            return None
        else:
            result = dict()
            for key in o.__dict__:
                k = key[1:]
                result[k] = o.__dict__[key]


SubmodelElementListSerializer()
