/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import iip.datatypes.KRec13Anon;
import iip.datatypes.TurnstilePlcOutput;
import iip.impl.StateServiceImpl;
import java.io.InputStream;
import java.time.Clock;

public class StateService
extends StateServiceImpl {
    private Turnstile fsm;
    private static StateService instance;

    protected StateService(ServiceKind kind) {
        super(kind);
        this.initiateStateMachine();
        instance = this;
    }

    protected StateService(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        this.initiateStateMachine();
        instance = this;
    }

    protected StateService(YamlService yaml) {
        super(yaml);
        this.initiateStateMachine();
        instance = this;
    }

    protected StateService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        this.initiateStateMachine();
        instance = this;
    }

    @Override
    public void processTurnstilePlcOutput(TurnstilePlcOutput data) {
        this.fsm.processTurnstilePlcOutput(data);
    }

    @Override
    public void processKRec13Anon(KRec13Anon data) {
        this.fsm.processKRec13Anon(data);
    }

    public void initiateStateMachine() {
        this.fsm = new Turnstile(this, Clock.systemDefaultZone());
    }

    protected class Turnstile
    extends AbstractStateMachine {
        private State currentState;
        private final StateService service;
        private final State lockedState;
        private final State unlockedState;

        public State getCurrentState() {
            return this.currentState;
        }

        public State getLockedState() {
            return this.lockedState;
        }

        public State getUnlockedState() {
            return this.unlockedState;
        }

        public Turnstile(StateService service, Clock clock) {
            super(clock);
            this.lockedState = new LockedState(this);
            this.unlockedState = new UnlockedState(this);
            this.service = service;
            this.setState(this.lockedState);
        }

        public void setState(State state) {
            this.currentState = state;
            this.markStateChange();
        }

        public void processTurnstilePlcOutput(TurnstilePlcOutput data) {
            if (data.getReady()) {
                this.currentState.push();
            }
            if (data.getMoney() >= 3.0) {
                this.currentState.coin();
            }
        }

        public void processKRec13Anon(KRec13Anon data) {
        }

        protected class LockedState
        extends AbstractState {
            public LockedState(Turnstile ctx) {
                super(ctx);
            }

            @Override
            public String getName() {
                return "locked";
            }

            @Override
            public void push() {
                this.getCtx().setState(this.getCtx().getUnlockedState());
            }
        }

        protected class UnlockedState
        extends AbstractState {
            public UnlockedState(Turnstile ctx) {
                super(ctx);
            }

            @Override
            public String getName() {
                return "unlocked";
            }

            @Override
            public void coin() {
                this.getCtx().setState(this.getCtx().getUnlockedState());
            }
        }

        public abstract class AbstractState
        implements State {
            private final Turnstile ctx;

            public AbstractState(Turnstile ctx) {
                this.ctx = ctx;
            }

            @Override
            public void push() {
                this.logIgnored("push");
            }

            @Override
            public void coin() {
                this.logIgnored("coin");
            }

            void logIgnored(String transName) {
                System.out.println("[FSM] Transition " + transName + " is not defined in state " + this.getName());
            }

            Turnstile getCtx() {
                return this.ctx;
            }
        }
    }

    protected abstract class AbstractStateMachine {
        private final Clock clock;
        private long lastStateChange;

        public AbstractStateMachine(Clock clock) {
            this.clock = clock;
            this.lastStateChange = this.now();
        }

        public long now() {
            return this.clock.millis();
        }

        public long millisSinceLastStateChange() {
            return this.now() - this.lastStateChange;
        }

        public boolean hasElapsed(long threshold) {
            return this.millisSinceLastStateChange() >= threshold;
        }

        public void markStateChange() {
            this.lastStateChange = this.now();
        }
    }

    public static interface State {
        public String getName();

        public void push();

        public void coin();
    }
}

