package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingConnIn.
 * Generated by: EASy-Producer.
 */
public class RoutingConnInSerializer implements Serializer<RoutingConnIn> {

    private static final Json MAPPER = Json.createInstance(RoutingConnIn.class);

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public RoutingConnIn from(byte[] data) throws IOException {
        return MAPPER.readValue(data, RoutingConnInImpl.class);
    }

    @Override
    public byte[] to(RoutingConnIn source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public RoutingConnIn clone(RoutingConnIn origin) throws IOException {
        return new RoutingConnInImpl(origin);
    }

    @Override
    public Class<RoutingConnIn> getType() {
        return RoutingConnIn.class;
    }

}
