package iip.datatypes;

import de.iip_ecosphere.platform.support.ConfiguredName;
import de.iip_ecosphere.platform.support.Ignore;
import de.iip_ecosphere.platform.support.StringUtils;

import iip.datatypes.AvaMqttOutput;

/**
 * Implementation of the application data type AvaMqttOutput.
 * Generated by: EASy-Producer.
 */
@ConfiguredName("AvaMqttOutput")
public class AvaMqttOutputImpl implements AvaMqttOutput {

    @ConfiguredName("xaxis")
    private String xaxis;
    @ConfiguredName("yaxis")
    private String yaxis;
    @ConfiguredName("zaxis")
    private String zaxis;

    /**
     * Default constructor. Fields are pre-allocated with default Java values.
     */
    public AvaMqttOutputImpl() {
    }

    /**
     * Copy constructor.
     *
     * @param from the instance to copy the values from
     */
    public AvaMqttOutputImpl(AvaMqttOutput from) {
        this.xaxis = from.getXaxis();
        this.yaxis = from.getYaxis();
        this.zaxis = from.getZaxis();
    }

    @Override
    @Ignore
    public String getXaxis() {
        return xaxis;
    }

    @Override
    @Ignore
    public void setXaxis(String value) {
        this.xaxis = value;
    }

    @Override
    @Ignore
    public String getYaxis() {
        return yaxis;
    }

    @Override
    @Ignore
    public void setYaxis(String value) {
        this.yaxis = value;
    }

    @Override
    @Ignore
    public String getZaxis() {
        return zaxis;
    }

    @Override
    @Ignore
    public void setZaxis(String value) {
        this.zaxis = value;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        hc += getXaxis() != null ? getXaxis().hashCode() : 0;
        hc += getYaxis() != null ? getYaxis().hashCode() : 0;
        hc += getZaxis() != null ? getZaxis().hashCode() : 0;
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        boolean eq;
        if (other instanceof AvaMqttOutput) {
            AvaMqttOutput oth = (AvaMqttOutput) other;
            eq = true;
            eq &= getXaxis() != null ? getXaxis().equals(oth.getXaxis()) : true;
            eq &= getYaxis() != null ? getYaxis().equals(oth.getYaxis()) : true;
            eq &= getZaxis() != null ? getZaxis().equals(oth.getZaxis()) : true;
        } else {
            eq = false;
        }
        return eq;
    }

    @Override
    public String toString() {
        return StringUtils.toStringShortStyle(this);
    }

}
