package iip.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingCommandImpl;
import iip.interfaces.RoutingSinkInterface;

/**
 * IIP-Ecosphere supporting service implementation for 'RoutingSink'.
 * Generated by: EASy-Producer.
 */
public abstract class RoutingSinkImpl extends DefaultServiceImpl implements RoutingSinkInterface {

    private List<DataIngestor<RoutingCommand>> routingCommandIngestors = new ArrayList<>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap<>();

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param kind the service kind
     */
    protected RoutingSinkImpl(ServiceKind kind) {
        super(kind);
        registerParameterConfigurers();
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param serviceId the id of the service
     * @param kind the service kind
     */
    protected RoutingSinkImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from YAML information.
     *
     * @param yaml the service information as read from YAML
     */
    protected RoutingSinkImpl(YamlService yaml) {
        super(yaml);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from a service id and a YAML artifact.
     *
     * @param serviceId the id of the service
     * @param ymlFile the YML file containing the YAML artifact with the service descriptor
     */
    protected RoutingSinkImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        registerParameterConfigurers();
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return paramConfigurers.keySet();
    }

    /**
     * Registers the configurers.
     */
    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachRoutingCommandIngestor(DataIngestor<RoutingCommand> ingestor) {
        if (ingestor != null) {
            routingCommandIngestors.add(ingestor);
        }
    }

    /**
     * Returns whether there are registered RoutingCommand ingestors.
     *
     * @return {@code true} if there are RoutingCommand ingestors, {@code false} else
     */
    protected boolean hasRoutingCommandIngestor() {
        return routingCommandIngestors.size() > 0;
    }

    /**
     * Returns the number of registered RoutingCommand ingestors.
     *
     * @return the number of RoutingCommand ingestors
     */
    protected int hasRoutingCommandIngestorCount() {
        return routingCommandIngestors.size();
    }

    /**
     * Sends {@code data} to all registered RoutingCommand ingestors.
     *
     * @param data the data to be sent
     */
    protected void ingestRoutingCommand(RoutingCommand data) {
        if (routingCommandIngestors.isEmpty()) {
            LoggerFactory.getLogger(getClass())
                .warn("No ingestor for RoutingCommand registered. Ignoring");
        }
        for (int i = 0; i < routingCommandIngestors.size(); i++) {
            routingCommandIngestors.get(i)
                .ingest(data);
        }
    }

    /**
     * Creates an actual instance of the output type RoutingCommand.
     */
    public RoutingCommand createRoutingCommand() {
        return createType(RoutingCommand.class, () -> new RoutingCommandImpl());
    }

}
