package iip.interfaces;

import de.iip_ecosphere.platform.services.environment.Service;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingTestData;

/**
 * IIP-Ecosphere service interface for 'myRoutingSource'.
 * Generated by: EASy-Producer.
 */
public interface MyRoutingSourceInterface extends Service {

    public static final String SERVICE_ID = "myRoutingSource";

    /**
     * Processes a data item of type "RoutingCommand" asynchronously. Use the respective ingestor for the return type to
     * pass back the result of processing.
     *
     * @param data the data item to be processed
     */
    public void processRoutingCommand(RoutingCommand data);

    /**
     * Synchronous source method, called to produce data items of type "RoutingTestData".
     *
     * @return the data value to be ingested
     */
    public RoutingTestData produceRoutingTestData();

}
