/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import iip.datatypes.Rec1;
import iip.datatypes.Rec1Impl;
import iip.interfaces.SimpleDataSourceInterface;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public abstract class SimpleDataSourceImpl
extends DefaultServiceImpl
implements SimpleDataSourceInterface {
    private String camIP = "127.0.0.1";
    private int camPort = -1;
    private List<DataIngestor<Rec1>> rec1Ingestors = new ArrayList<DataIngestor<Rec1>>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();

    protected SimpleDataSourceImpl(ServiceKind kind) {
        super(kind);
        this.registerParameterConfigurers();
    }

    protected SimpleDataSourceImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        this.registerParameterConfigurers();
    }

    protected SimpleDataSourceImpl(YamlService yaml) {
        super(yaml);
        this.registerParameterConfigurers();
    }

    protected SimpleDataSourceImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        this.registerParameterConfigurers();
    }

    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    public Set<String> getParameterNames() {
        return this.paramConfigurers.keySet();
    }

    protected void registerParameterConfigurers() {
        AbstractService.addConfigurer(this.paramConfigurers, (String)"camIP", String.class, (TypeTranslator)TypeTranslators.JSON_STRING, v -> this.setParameterCamIP((String)v), () -> this.getParameterCamIP(), (String)"iip.app.simpleMesh.camIP");
        AbstractService.addConfigurer(this.paramConfigurers, (String)"camPort", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> this.setParameterCamPort((int)v), () -> this.getParameterCamPort(), (String)"iip.app.simpleMesh.camPort");
    }

    public void setParameterCamIP(String camIP) throws ExecutionException {
        this.camIP = camIP;
    }

    public String getParameterCamIP() {
        return this.camIP;
    }

    public void setParameterCamPort(int camPort) throws ExecutionException {
        this.camPort = camPort;
    }

    public int getParameterCamPort() {
        return this.camPort;
    }

    @Override
    public void attachRec1Ingestor(DataIngestor<Rec1> ingestor) {
        if (ingestor != null) {
            this.rec1Ingestors.add(ingestor);
        }
    }

    protected boolean hasRec1Ingestor() {
        return this.rec1Ingestors.size() > 0;
    }

    protected int hasRec1IngestorCount() {
        return this.rec1Ingestors.size();
    }

    protected void ingestRec1(Rec1 data) {
        if (this.rec1Ingestors.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).warn("No ingestor for Rec1 registered. Ignoring");
        }
        for (int i = 0; i < this.rec1Ingestors.size(); ++i) {
            this.rec1Ingestors.get(i).ingest((Object)data);
        }
    }

    public Rec1 createRec1() {
        return (Rec1)this.createType(Rec1.class, () -> new Rec1Impl());
    }
}

