package iip.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;

import iip.datatypes.Feedback;
import iip.datatypes.FeedbackImpl;
import iip.interfaces.SimpleDataReceiverInterface;

/**
 * IIP-Ecosphere supporting service implementation for 'Simple Data Receiver'.
 * Generated by: EASy-Producer.
 */
public abstract class SimpleDataReceiverImpl extends DefaultServiceImpl implements SimpleDataReceiverInterface {

    private List<DataIngestor<Feedback>> feedbackIngestors = new ArrayList<>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap<>();

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param kind the service kind
     */
    protected SimpleDataReceiverImpl(ServiceKind kind) {
        super(kind);
        registerParameterConfigurers();
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param serviceId the id of the service
     * @param kind the service kind
     */
    protected SimpleDataReceiverImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from YAML information.
     *
     * @param yaml the service information as read from YAML
     */
    protected SimpleDataReceiverImpl(YamlService yaml) {
        super(yaml);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from a service id and a YAML artifact.
     *
     * @param serviceId the id of the service
     * @param ymlFile the YML file containing the YAML artifact with the service descriptor
     */
    protected SimpleDataReceiverImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        registerParameterConfigurers();
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return paramConfigurers.keySet();
    }

    /**
     * Registers the configurers.
     */
    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachFeedbackIngestor(DataIngestor<Feedback> ingestor) {
        if (ingestor != null) {
            feedbackIngestors.add(ingestor);
        }
    }

    /**
     * Returns whether there are registered Feedback ingestors.
     *
     * @return {@code true} if there are Feedback ingestors, {@code false} else
     */
    protected boolean hasFeedbackIngestor() {
        return feedbackIngestors.size() > 0;
    }

    /**
     * Returns the number of registered Feedback ingestors.
     *
     * @return the number of Feedback ingestors
     */
    protected int hasFeedbackIngestorCount() {
        return feedbackIngestors.size();
    }

    /**
     * Sends {@code data} to all registered Feedback ingestors.
     *
     * @param data the data to be sent
     */
    protected void ingestFeedback(Feedback data) {
        if (feedbackIngestors.isEmpty()) {
            LoggerFactory.getLogger(getClass())
                .warn("No ingestor for Feedback registered. Ignoring");
        }
        for (int i = 0; i < feedbackIngestors.size(); i++) {
            feedbackIngestors.get(i)
                .ingest(data);
        }
    }

    /**
     * Creates an actual instance of the output type Feedback.
     */
    public Feedback createFeedback() {
        return createType(Feedback.class, () -> new FeedbackImpl());
    }

}
