/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import iip.datatypes.Feedback;
import iip.datatypes.FeedbackImpl;
import iip.interfaces.SimpleDataReceiverInterface;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SimpleDataReceiverImpl
extends DefaultServiceImpl
implements SimpleDataReceiverInterface {
    private List<DataIngestor<Feedback>> feedbackIngestors = new ArrayList<DataIngestor<Feedback>>();
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();

    protected SimpleDataReceiverImpl(ServiceKind kind) {
        super(kind);
        this.registerParameterConfigurers();
    }

    protected SimpleDataReceiverImpl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        this.registerParameterConfigurers();
    }

    protected SimpleDataReceiverImpl(YamlService yaml) {
        super(yaml);
        this.registerParameterConfigurers();
    }

    protected SimpleDataReceiverImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        this.registerParameterConfigurers();
    }

    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    public Set<String> getParameterNames() {
        return this.paramConfigurers.keySet();
    }

    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachFeedbackIngestor(DataIngestor<Feedback> ingestor) {
        if (ingestor != null) {
            this.feedbackIngestors.add(ingestor);
        }
    }

    protected boolean hasFeedbackIngestor() {
        return this.feedbackIngestors.size() > 0;
    }

    protected int hasFeedbackIngestorCount() {
        return this.feedbackIngestors.size();
    }

    protected void ingestFeedback(Feedback data) {
        if (this.feedbackIngestors.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).warn("No ingestor for Feedback registered. Ignoring");
        }
        for (int i = 0; i < this.feedbackIngestors.size(); ++i) {
            this.feedbackIngestors.get(i).ingest((Object)data);
        }
    }

    public Feedback createFeedback() {
        return (Feedback)this.createType(Feedback.class, () -> new FeedbackImpl());
    }
}

