package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.transport.serialization.Serializer;

import iip.datatypes.*;

/**
 * JSON transport serializer for Rec13.
 * Generated by: EASy-Producer.
 */
public class Rec13Serializer implements Serializer<Rec13> {

    private static final Json MAPPER = Json.createInstance(Rec13.class);

    static {
        MAPPER.handleIipDataClasses();
    }

    @Override
    public Rec13 from(byte[] data) throws IOException {
        return MAPPER.readValue(data, Rec13Impl.class);
    }

    @Override
    public byte[] to(Rec13 source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    @Override
    public Rec13 clone(Rec13 origin) throws IOException {
        return new Rec13Impl(origin);
    }

    @Override
    public Class<Rec13> getType() {
        return Rec13.class;
    }

}
